 aR  w Q m
Z<      h	 oP       nSystem-wide$NOLIST
$COMPACT (OS -CONST IN CODE- HAS List, ListPlm, Elsewhere, Common, Con;
$         EXPORTS RedoListsPatch)

{ Elsewhere, Common & Con are considered part of this subsystem }
{ because they are short calls to be resolved by Releasing.     }

MODULE List;

{------------------ IMPORTS ----------------------}

$INCLUDE(``Incs_Pas`Byte_P~Inc~)
$INCLUDE(``Incs_Pas`Common~Inc~)
$INCLUDE(``Incs_Pas`Con_Pas~Inc~)
$INCLUDE(``Incs_Pas`Directry~Inc~)
$INCLUDE(``Incs_Pas`Field_T~Inc~)
$INCLUDE(``Incs_Pas`Math~Inc~)
$INCLUDE(``Incs_Pas`Msg_T~Inc~)
$INCLUDE(``Incs_Pas`Msg_P~Inc~)
$INCLUDE(``Incs_Pas`String_T~Inc~)
$INCLUDE(``Incs_Pas`String_P~Inc~)
$INCLUDE(``Incs_Pas`Os_T~Inc~)
$INCLUDE(``Incs_Pas`Os_P~Inc~)
$INCLUDE(``Incs_Pas`Window_T~Inc~)

PUBLIC Elsewhere;
  VAR wildCardString:  StringPtr;
      programsSubject: StringPtr;
  FUNCTION GetList (theList: ListType; VAR entries: Integer): StringPtr;
  FUNCTION TranslateString (VAR string: BYTES;  pDestHi, pDestLo: Integer;
                            index: Word; outdex: Word): Boolean;

PUBLIC ListPlm;
  VAR wildTdRunSpaceString: StringPtr;
  FUNCTION FindListIndex (str: StringPtr):Integer;

PUBLIC List;
  CONST numLists = 10;
        nonSortedItems = '0211111100';
  TYPE ListType = (kindList, fontList, printerList, plotterList, 
                   serialList, modemList, parallelList, protocolList,
                   libraryList, applicationsList);
  FUNCTION GetFindTitleMsg (title: StringPtr): StringPtr;
  PROCEDURE RedoListsPatch;
  PROCEDURE MsgDispose (msg: MessagePtr);
  PROCEDURE SetSearchSequence
   (conn: WORD; dontFindVolumeNames,dontFindSearchable,dontFindLocal: Boolean);

PRIVATE List;
  CONST setTheWildcard = TRUE;
        dirForward = 0;
        listLengthTag = 18;
        listTag = 19;
        eOK = 0;
        escapeKey = 1BH;
$EJECT

{                  GetFindTitleMsg

  This routine is called if FindThisTitle does not find the desired file.
  It returns a message asking the user to insert the proper disk.  The
  name of the application being searched for will be included in the message
  if the title string is of the form 'wildcard~run kind~'.  
}
FUNCTION GetFindTitleMsg (title: StringPtr): StringPtr;
VAR msgString, kind, kindListString, applicationsListString: StringPtr;
    appName: StringPtr;
    kindEntries, applicationsEntries, index: Integer;
    ch: Char;
    len: Word;
BEGIN
appName := NIL;
IF title^.len > 6 THEN
  BEGIN
  len := title^.len;
  title^.len := 6;
  IF EqualStrings (title, wildTdRunSpaceString) THEN
    BEGIN
    kind := newString (len - 6);
    MoveBytes (title^.chars[7], kind^.chars, len - 6);
    kind^.len := len - 7; { Don't include the trailing ~ }
    kindListString := GetList (kindList, kindEntries);
    IF LookupNameInList (kindListString, kindEntries, kindList, kind, index) =
       equal THEN
      BEGIN { The kind is in the list - look for the application }
      applicationsListString := GetList (applicationsList, applicationsEntries);
      appName := SubStringLit (applicationsListString^.chars, '~', index);
      FreeString (applicationsListString);
      END;
    FreeString (kindListString);
    FreeString (kind);
    END;
  title^.len := len;
  END;

IF appName = NIL THEN
  BEGIN
  { It should say 'Title: foo, Kind: mumble -- not found' }
  appName := ConcatStrings(NewStringLit('Title: '),
                           ConcatStrings(SubProperty (title, 1),
                                         NewStringLit (', Kind: ')));
  appName := ConcatStrings (appName, 
                            ConcatStrings(SubProperty(title, 2),
                                          NewStringLit(' --')));
  END;

GetFindTitleMsg := ConcatStrings (appName, NewStringLit (' not found'));
END;
$EJECT

PROCEDURE SetSearchSequence (conn : WORD; 
                             dontFindVolumeNames, 
                             dontFindSearchable, 
                             dontFindLocal: Boolean);
CONST massStorageBit = 1;
      visibleBit     = 2;
      localBit       = 4;
      searchableBit  = 128;
      volumeNameBit  = 2048;
VAR error: WORD;
    mask: WORD;
    status: RECORD
              entryId : BYTE;
              length : WORD;
              mask: Word;
              value: Word;
            END;
BEGIN
status.entryId := 251;  { set the mask }
status.length := 4;     { two words    }

mask := massStorageBit + visibleBit;
IF dontFindLocal THEN mask       := mask + localBit;
IF dontFindSearchable THEN mask  := mask + searchableBit;
IF dontFindVolumeNames THEN mask := mask + volumeNameBit;
status.mask := mask;
status.value := massStorageBit;

OsSetStatus(conn, status, status.Length + 3, error);
END;

{****************************************************************************}

PROCEDURE MsgDispose (msg: MessagePtr);
BEGIN
Dispose (msg^.field);
Dispose (msg);
END;

{****************************************************************************}

PROCEDURE ChangeSizeOfString (VAR str: StringPtr; len: Word);
VAR temp: StringPtr;
BEGIN
temp := NewString (len);
CopyString (str, temp);
FreeString (str);
str := temp;
END;

{****************************************************************************}

{ This routine puts a list into the user profile - It frees is argument }

PROCEDURE PutLists (lists: StringPtr);
VAR lenTag, error: Word;
BEGIN
OsPutProperty (listLengthTag, 2, lists^.len, error);
IF error = 0 THEN
  OsPutProperty (listTag, lists^.len, lists^.chars, error);
FreeString (lists);
END;
$EJECT

{ name is inserted before the index'th item in list }
PROCEDURE InsertAtIndex (VAR list: StringPtr;
                         VAR entries: Integer;
                         theList: ListType;
                         VAR name: StringPtr; 
                         index: Integer);
VAR pos, i: Integer;
    offset: Word;
    dummy: Boolean;
BEGIN
IF index > 0 THEN
  BEGIN
  AppendAnyChar (name, '~');
  IF index > entries THEN
    BEGIN { Put it at the end }
    list := ConcatStrings (list, name);
    name := NIL;
    END
  ELSE
    BEGIN { The indexth item is greater }
    pos := 1;
    FOR i := 1 TO index - 1 DO
      BEGIN
      dummy := FindByte (list^.chars[pos], '~', 
                         list^.len - pos + 1, offset);
      pos := pos + offset + 1;
      END;
    IF list^.max < list^.len + name^.len THEN
      ChangeSizeOfString(list, list^.len + name^.len);

    dummy := InsertInString (name, list, pos);
    END;
  entries := entries + 1;
  END;
END; { InsertAtIndex }
$EJECT

FUNCTION LookupNameInList (list: StringPtr;
                           entries: Integer;
                           theList: ListType; 
                           name: StringPtr; 
                           VAR index: Integer): Comparison;
VAR compare: Comparison;
    skip: Integer;
    str: StringPtr;
BEGIN
compare := less;
index := 0;

skip := Ord(nonSortedItems[Ord(theList) + 1]) - Ord('0');

WHILE (compare = less) AND (index < entries) DO
  BEGIN
  index := index + 1;
  str := SubStringLit (list^.chars, '~', index);
  IF skip > 0 THEN 
    skip := skip - 1  { Skip the non-sorted items }
  ELSE
    compare := CompareStrings (str, name);
  FreeString (str);
  END;
LookupNameInList := compare;
END;

{****************************************************************************}

PROCEDURE ListInsert (VAR list: StringPtr;
                      VAR entries: Integer;
                      theList: ListType; 
                      VAR name: StringPtr; 
                      VAR index: Integer);
VAR compare: Comparison;
BEGIN
compare := LookupNameInList (list, entries, theList, name, index);

IF compare = less THEN
  index := entries + 1; { Insert it at the end }

IF (compare <> equal) THEN
  InsertAtIndex (list, entries, theList, name, index)
ELSE
  index := 0;
FreeString (name);
END;
$EJECT

PROCEDURE RedoListsPatch;
LABEL 99;
CONST fromShortAppl = 2;
      toShortKind   = 0;
VAR  lists: Array[ListType] OF StringPtr;
     entries: Array[ListType] OF Integer;
     tmp, kind, software, deviceName, name: StringPtr;
     deviceEndFile, endFile, dummy: BOOLEAN;
     conn, deviceConn, status, listIndex: WORD;
     listStrings: StringPtr;
     ch: Char;
     index: Integer;
BEGIN
deviceName := NewString(60);
software   := NewString(80);
kind       := NewString(40);
FOR listIndex := 0 TO numLists - 1 DO
  lists[ListType(listIndex)] := GetList (ListType(listIndex),
                                         entries[ListType(listIndex)]);
{open the root directory}
status := OpenDirectory(deviceName, deviceConn);
IF status <> 0 THEN GOTO 99;
SetSearchSequence (deviceConn, true,   { Don't check volume names }
                               true,   { Don't check slow remote devices }
                               false); { Check local and remote devices }
  
REPEAT
  status := GetDirItem(deviceConn, wildCardString, SetTheWildCard,
                       DirForward, deviceName, deviceEndFile);
  IF (NOT deviceEndFile) AND (status = 0) THEN 
    BEGIN
    dummy := InsertCharInString ('`', deviceName, 1);
    AppendString (deviceName, programsSubject);

    status := OpenDirectory(devicename, conn);
    IF status = 0 THEN
      REPEAT
        status := GetDirItem(conn, wildCardString, SetTheWildCard,
                             DirForward, software, endFile);
        software^.dummy := software^.len;
  
        IF ConKeyPressed THEN
          IF ConPeekChar = Chr(escapeKey) THEN
            BEGIN
            endFile := true;
            deviceEndFile := true;
            ch := ConCharIn;
            END;
        IF (NOT endFile) AND (status = 0) THEN
          BEGIN
          { Change the call from SubProperty to OsChangeExtension 
            to support InteGRiD }
          OsChangeExtension (software^.dummy, returnType, kind^.dummy, status);
          kind^.len := kind^.dummy;

          IF kind^.len <> 0 THEN
            BEGIN
            name := SubProperty (software, 1);
            listIndex := FindListIndex (kind);
            IF listIndex < numLists THEN { It was found }
              BEGIN
              IF listIndex = Ord (kindList) THEN
                BEGIN
                IF kind^.len > 3 THEN { 'Run Kind' case }
                  BEGIN
                  tmp := NewString (kind^.len - 4);
                  MoveBytes (kind^.chars[5], tmp^.chars[1], tmp^.max);
                  tmp^.len := tmp^.max;
                  END
                ELSE { InteGRiD 'Run' case }
                  BEGIN

                  { All of this should eventually be replaced with: }

                  {
                  tmp := NewString (maxKindLen);
                  name^.dummy := name^.len;
                  OsChangeExtension
                   (name^.dummy, returnSubtype, tmp^.dummy, status);
                  tmp^.len := tmp^.dummy;
                  }

                  tmp := NewString (Max (name^.len, 3));
                  MoveBytes (name^.chars[1], tmp^.chars[1], name^.len);
                  tmp^.len := name^.len;
                  tmp^.dummy := name^.len;

                  { This is a very strange way of passing PLM NULLPTR}
                  IF TranslateString (tmp^.dummy, 0FFFFH, 000FH,
                                      fromShortAppl, toShortKind) THEN
                    tmp^.len := tmp^.dummy
                  ELSE
                    tmp^.len := 0;
                  END;
                IF tmp^.len = 0 THEN
                  BEGIN
                  FreeString (tmp);
                  END
                ELSE
                  BEGIN
                  ListInsert(lists[kindList], entries[kindList], 
                             kindList, tmp, index);
                  InsertAtIndex (lists[applicationsList], 
                                 entries[applicationsList], 
                                 applicationsList, name, index);
                  END;
                END
              ELSE
                ListInsert (lists[ListType(listIndex)], 
                            entries[Listtype(listIndex)], 
                            ListType(listIndex), name, index);
              END;
            END;
          FreeString(name);
          END;
      UNTIL endFile OR (status <> 0);
    OSDetach(conn, status);
    END;
  
  UNTIL deviceEndFile;
  
listStrings := NIL;
FOR listIndex := 0 TO numLists - 1 DO
  BEGIN
  AppendAnyChar (lists[ListType(listIndex)], '|');
  listStrings := ConcatStrings (listStrings, lists[ListType(listIndex)]);
  END;
PutLists (listStrings);

OSDetach(deviceConn, status);

99: 
FreeString (software);
FreeString (deviceName);
FreeString (kind);
END;
.
